' Ten kod pochodzi z ksiki "ASP.NET 2.0. Gotowe rozwizania" autorstwa
' Imara Spaanjaarsa, Paula Wiltona and Shawna Livermore, wydanej przez Wrox.
' Polska edycja: Wydawnictwo Helion.
' Copyright 2006 by Wiley Publishing Inc.
' Informacja o tej ksice jest dostpna na stronie www.wrox.com.  
' Odwied p2p.wrox.com aby podyskutowa o tym kodzie na forach Wrox.

''' <summary>
''' HourPicker wywietla wasn list rozwijan z godzinami. Pierwsza i ostatnia godzina z listy moe
''' byc ustawiona we wasciwociach StartTime i EndTime.
''' </summary>
Partial Class HourPicker
  Inherits System.Web.UI.UserControl

  ''' <summary>
  ''' Pobiera lub ustawia godzin wybran z listy rozwijanej.
  ''' </summary>
  ''' <returns>Warto cakowita reprezentujca wybran godzin lub -1, jeli nie wybrano adnej godziny.</returns>
  Public Property SelectedHour() As Integer
    Get
      If lstHour.SelectedIndex >= 0 Then
        Return Convert.ToInt32(lstHour.SelectedValue)
      Else
        Return -1
      End If
    End Get
    Set(ByVal value As Integer)
      If lstHour.Items.FindByValue(value.ToString()) IsNot Nothing Then
        lstHour.Items.FindByValue(value.ToString()).Selected = True
      End If
    End Set
  End Property

  ''' <summary>
  ''' Pobiera lub ustawia pierwsz godzin dostpn w licie rozwijanej.
  ''' </summary>
  ''' <remarks>Ta waiwo musi mie warto pomidzy 0 and 23.</remarks>
  Public Property StartTime() As Integer
    Get
      If ViewState("StartTime") IsNot Nothing Then
        Return Convert.ToInt32(ViewState("StartTime"))
      Else
        Return 0
      End If
    End Get
    Set(ByVal value As Integer)
      If value >= 0 And value <= 23 Then
        ViewState("StartTime") = value
        CreateListItems()
      Else
        Throw New ArgumentOutOfRangeException("StartTime", "StartTime musi by pomidzy 0 i 23")
      End If
    End Set
  End Property

  ''' <summary>
  ''' Pobiera lub ustawia ostatni godzin dostpn w licie rozwijanej.
  ''' </summary>
  ''' <remarks>Ta waiwo musi mie warto pomidzy 0 and 23.</remarks>
  Public Property EndTime() As Integer
    Get
      If ViewState("EndTime") IsNot Nothing Then
        Return Convert.ToInt32(ViewState("EndTime"))
      Else
        Return 23
      End If
    End Get
    Set(ByVal value As Integer)
      If value >= 0 And value <= 23 Then
        ViewState("EndTime") = value
        CreateListItems()
      Else
        Throw New ArgumentOutOfRangeException("EndTime", "EndTime ma by between 0 and 23")
      End If
    End Set
  End Property

  ''' <summary>
  ''' Tworzy list dodajc wartoci dla kadej godziny pomidzy StartTime i EndTime.
  ''' </summary>
  ''' <remarks>Ta metoda jest wywoywana za kazdym razem, gdy waciwo StartTime lub EndTime jest aktualizowana, aby zapewni e lista jest zawsze zsynchronizowana z tymi waciwociami.</remarks>
  Private Sub CreateListItems()
    lstHour.Items.Clear()
    For i As Integer = StartTime To EndTime
      lstHour.Items.Add(New ListItem(i.ToString() & ":00", i.ToString()))
    Next
  End Sub

End Class
